<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class SessionExpired
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @param  string|null  ...$guards
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (!$request->session()->has('user')) { // Change 'user_id' to your session key
            return redirect('/')->with('error_login', 'Your session has expired. Please log in again.');
        }

        return $next($request);
    }
}
