<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Auth\AuthController;

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\WalletTransactionController;
use App\Http\Controllers\ManageCustomerController;
use App\Http\Controllers\SupportController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\AccountSettingController;
use App\Http\Controllers\HomeController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });


Route::get('/', [AuthController::class, 'index'])->name('login');

Route::post('post-login', [AuthController::class, 'postLogin'])->name('login.post'); 
Route::post('post-register', [AuthController::class, 'postRegistration'])->name('register.post');
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::middleware(['session.expired'])->group(function () {



Route::get('/user', [HomeController::class, 'user'])->name('user.user');

Route::get('/profile', [HomeController::class, 'profile'])->name('user.profile');

Route::get('/user_lottery', [HomeController::class, 'user_lottery'])->name('user.user_lottery');

Route::get('/user_referral', [HomeController::class, 'user_referral'])->name('user.user_referral');

Route::get('/user_transaction', [HomeController::class, 'user_transaction'])->name('user.user_transaction');

Route::post('/avatar', [ProfileController::class, 'updateAvatar'])->name('avatar');
Route::get('logout', [AuthController::class, 'logout'])->name('logout');
Route::post('/update_personal', [ProfileController::class, 'update_personal'])->name('update_personal');
Route::post('/update_email', [ProfileController::class, 'update_email'])->name('update_email');
Route::post('/update_number', [ProfileController::class, 'update_number'])->name('update_number');
Route::post('/update_password', [ProfileController::class, 'update_password'])->name('update_password');

Route::get('/user_info', [HomeController::class, 'user_info'])->name('user_info');
Route::get('/user_transaction', [HomeController::class, 'user_transaction'])->name('user_transaction');
Route::get('/user_referral', [HomeController::class, 'user_referral'])->name('user_referral');
    Route::get('/user_support', [HomeController::class, 'user_support'])->name('user_support');
Route::post('/insert_support', [HomeController::class, 'insert_support'])->name('insert_support');
Route::get('/faq', [HomeController::class, 'faq'])->name('faq');

});

Route::get('/contact', [HomeController::class, 'contact'])->name('contact');



// Route::get('business_area', function () {
//     return view('business_area');
// });


// Route::get('region', function () {
//     return view('region');
// });

// Route::get('country', function () {
//     return view('country');
// });

// Route::get('city', function () {
//     return view('city');
// });

// Route::get('state', function () {
//     return view('state');
// });

// Route::get('template_manager', function () {
//     return view('template_manager');
// });

// Route::get('price_manager', function () {
//     return view('price_manager');
// });

// Route::get('donor', [DonorController::class, 'index']); 

// Route::get('applicant', [ApplicantController::class, 'index']); 

// Route::get('add_expert', [ExpertController::class, 'index']); 

// Route::get('view_expert', [ExpertController::class, 'view'])->name('view_expert'); 
// Route::post('add_expert/district_list', [ExpertController::class, 'district_list'])->name('add_expert.district_list'); 


// Route::post('add_expert/city_list', [ExpertController::class, 'city_list'])->name('add_expert.city_list'); 

// Route::post('add_expert/create', [ExpertController::class, 'create'])->name('add_expert.create'); 

// Route::get('add_expert/edit/{id}', [ExpertController::class, 'edit'])->name('add_expert.edit'); 



// Route::post('add_expert/update/{id}', [ExpertController::class, 'update'])->name('add_expert.update'); 


// Route::post('faq/create', [FaqController::class, 'create'])->name('faq.create'); 
// Route::get('faq', [FaqController::class, 'index']); 
// Route::get('faq/edit/{id}', [FaqController::class, 'edit'])->name('faq.edit'); 
// Route::get('faq/view', [FaqController::class, 'view'])->name('faq.view'); 