@extends('layout')
@section('title','User Info')
@section('content')
<div class="inner-hero-section style--five">
         </div>
           <div class="mt-minus-150 pb-120">
            <div class="container">
               <div class="row">
                  @include('user_card')
                  <div class="col-lg-8 mt-lg-0 mt-5">
                     <div class="user-info-card" id="personal_details_label">
                        <div class="user-info-card__header">
                           <h3 class="user-info-card__title">Personal Details</h3>
                           <button type="button" id="personal_details"><i class="far fa-edit"></i> Edit</button>
                        </div>
                        <ul class="user-info-card__list" >
                            
                           <li>
                              <span class="caption">Name</span>
                              <span class="value">{{$customer_data->prefix ?? ''}} {{$customer_data->first_name ?? ''}} {{$customer_data->last_name ?? ''}}</span>
                           </li>
                           <li>
                              <span class="caption">Date of Birth</span>
                              <span class="value">{{$customer_data->dob ?? ''}}</span>
                           </li>
                           <li>
                              <span class="caption">Address</span>
                              <span class="value">{{$customer_data->address_line_1 ?? ''}}</span>
                           </li>
                           <li>
                              <span class="caption">Time Zone</span>
                              <span class="value">{{$customer_data->timezone ?? ''}}</span>
                           </li>
                           <li>
                              <span class="caption">Status</span>
                              <span class="value status-active">@if($customer_data->status == 1) Active @else In-Active @endif </span>
                           </li>
                        </ul>
                     </div>
                     <div class="user-info-card" id="personal_details_div" style="display:none;">
                        <div class="user-info-card__header">
                           <h3 class="user-info-card__title">Personal Details</h3>
                           <button type="button" id="personal_details_cancel"><i class="far fa-times-circle"></i> Cancel</button>
                        </div>
                        <ul class="user-info-card__list">
                            <form action ="{{route('update_personal')}}" method="POST">
                                @csrf
                                <input type="hidden" name="user_id" id="user_id" value="{{$customer_data->id}}" />
                                <input type="hidden" name="action" id="action" value="personal" />
                                <li>
                              <span class="caption">Name</span>
                              <span class="value"><input type="text" name="first_name" id="first_name" placeholder="Enter Your Name" value="{{$customer_data->first_name ?? ''}}"></span>
                              
                           </li>
                           <li>
                              <span class="caption">Date of Birth</span>
                              <span class="value"><input type="date" name="dob" id="dob" placeholder="" value="{{$customer_data->dob ?? ''}}"></span>
                           </li>
                           <li>
                              <span class="caption">Address</span>
                              <span class="value"><input type="text" name="address_line_1" id="address_line_1" placeholder="Enter Your Address" value="{{$customer_data->address_line_1 ?? ''}}"></span>
                           </li>
                           <li>
                              <span class="caption">Time Zone</span>
                              <span class="value"><input type="text" name="timezone" id="timezone" placeholder="Enter Your Time zone" value="{{$customer_data->timezone ?? ''}}"></span>
                           </li>
                           <li>
                              <span class="caption">Status</span>
                              <span class="value">
                                  <select name="status" id="status">
                                        <option value="1">Active</option>
                                        <option value="0">In-Active</option>
                                    </select> 
                                </span>
                           </li>
                           <li>
                               <input type="submit" name="submit" id="submit" value="Update" />
                           </li>
                            </form>
                           
                        </ul>
                     </div>
                     
                     <!-- user-info-card end -->
                     <div class="user-info-card" id="email_address_label">
                        <div class="user-info-card__header">
                           <h3 class="user-info-card__title">Email Addresses</h3>
                           <button type="button" id="email_address"><i class="far fa-edit"></i> Edit</button>
                        </div>
                        <ul class="user-info-card__list">
                           <li>
                              <span class="caption">Email</span>
                              <span class="value">{{$customer_data->email ?? ''}}</span>
                           </li>
                        </ul>
                     </div>
                     
                     <div class="user-info-card" id="email_address_div" style="display:none;">
                        <div class="user-info-card__header">
                           <h3 class="user-info-card__title">Email Addresses</h3>
                           <button type="button" id="email_address_cancel"><i class="far fa-times-circle"></i> Cancel</button>
                        </div>
                        <ul class="user-info-card__list">
                            <form action ="{{route('update_email')}}" method="POST">
                                @csrf
                                <input type="hidden" name="user_id" id="user_id" value="{{$customer_data->id}}" />
                               <input type="hidden" name="action" id="action" value="email" />
                           <li>
                              <span class="caption">Email</span>
                              <span class="value"><input type="text" name="email" id="email" placeholder="Enter Your Time zone" value="{{$customer_data->email ?? ''}}"></span>
                           </li>
                           
                           <li>
                               <input type="submit" name="submit" id="submit" value="Update" />
                           </li>
                            </form>
                           
                        </ul>
                     </div>
                     
                     <!-- user-info-card end -->
                     <div class="user-info-card" id="number_label">
                        <div class="user-info-card__header">
                           <h3 class="user-info-card__title">Phone</h3>
                           <button type="button" id="number"><i class="far fa-edit"></i> Edit</button>
                        </div>
                        <ul class="user-info-card__list">
                           <li>
                              <span class="caption">Mobile</span>
                              <span class="value">{{$customer_data->mobile ?? ''}}</span>
                           </li>
                        </ul>
                     </div>
                     
                     <div class="user-info-card" id="number_div" style="display:none;">
                        <div class="user-info-card__header">
                           <h3 class="user-info-card__title">Mobile</h3>
                           <button type="button" id="number_cancel"><i class="far fa-times-circle"></i> Cancel</button>
                        </div>
                        <ul class="user-info-card__list">
                            <form action ="{{route('update_number')}}" method="POST">
                                @csrf
                                <input type="hidden" name="user_id" id="user_id" value="{{$customer_data->id}}" />
                               <input type="hidden" name="action" id="action" value="number" />
                           <li>
                              <span class="caption">Mobile</span>
                              <span class="value"><input type="text" name="mobile" id="mobile" placeholder="Enter Your Time zone" value="{{$customer_data->mobile ?? ''}}"></span>
                           </li>
                           
                           <li>
                               <input type="submit" name="submit" id="submit" value="Update" />
                           </li>
                            </form>
                           
                        </ul>
                     </div>
                     <!-- user-info-card end -->
                     <div class="user-info-card" id="password_label">
                        <div class="user-info-card__header">
                           <h3 class="user-info-card__title">Security</h3>
                           <button type="button" id="password"><i class="far fa-edit"></i> Edit</button>
                        </div>
                        <ul class="user-info-card__list">
                           <li>
                              <span class="caption">Password</span>
                              <span class="value user-password">***************</span>
                           </li>
                        </ul>
                     </div>
                     
                     <div class="user-info-card" id="password_div" style="display:none;">
                        <div class="user-info-card__header">
                           <h3 class="user-info-card__title">Security</h3>
                           <button type="button" id="password_cancel"><i class="far fa-times-circle"></i> Cancel</button>
                        </div>
                        <ul class="user-info-card__list">
                            <form action ="{{route('update_password')}}" method="POST">
                                @csrf
                                <input type="hidden" name="user_id" id="user_id" value="{{$customer_data->id}}" />
                               <input type="hidden" name="action" id="action" value="number" />
                           <li>
                              <span class="caption">Password</span>
                              <span class="value"><input type="password" name="password" id="password" placeholder="" value=""></span>
                           </li>
                           
                           <li>
                               <input type="submit" name="submit" id="submit" value="Update" />
                           </li>
                            </form>
                           
                        </ul>
                     </div>
                     <!-- user-info-card end -->
                  </div>
               </div>
            </div>
         </div>
            
         


@endsection



