<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Country;
use App\Models\Region;
use App\Models\State;
use App\Models\City;
use App\Models\Customer;
use App\Models\Customer_group;
use App\Models\Business_Partner;
use App\Models\Lottery;
use App\Models\Sale;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use App\Models\Support_Category;
use Carbon\Carbon;
use App\Models\Support;

use App\Models\Faq;
class HomeController extends Controller
{
    /**

     * Write code on Method

     *

     * @return response()

     */

    public function index()
    {
       
        return view('index');
    }
    
    public Function user(){
        $user= Session::get('user');
        $customer = Customer::find($user['id']);
        $sale = Sale::where('customer_id',$user['customer_id'])->count();
        $sale_cal = Sale::where('customer_id',$user['customer_id'])->sum('price');
    //     $customer_lottery = DB::table('sales')
    // ->join('lotteries', 'sales.lottery_id', '=', 'lotteries.id')
    // ->where('sales.customer_id', $user['customer_id'])
    // ->select('lotteries.lottery_name','lotteries.winner_status', 'sales.*') // You can customize the columns you want
    // ->get();

        $customer_lottery = DB::table('lotteries as l')
    ->join('sales as s', 'l.id', '=', 's.lottery_id')
    ->join('business_partners as bp', 's.partner_id', '=', 'bp.id')
    ->select(
        'l.lottery_name',
        'l.ticket_id',
        'bp.business_name',
        'bp.poc_first_name',
        'bp.poc_email',
        'bp.poc_mobile',
        's.price',
        's.qty',
        's.discount',
        's.tax',
        's.status'
    )->where('s.customer_id',$user['customer_id'])
    ->orderBy('s.created_at', 'desc') // or 's.id' if no timestamps
    ->limit(3)
    ->get();

        return view('user',compact('customer','sale','sale_cal','customer_lottery'));
    }
    
    public function user_info()
    {
       $user = Session::get('user');
        $customer_data = Customer::find($user['id']);
        return view('profile',compact('customer_data'));
    }

    public function user_lottery()
    {
       
        return view('user_lottery');
    }
    
    public function user_referral()
    {
       $business_partner = Business_Partner::all();
       $results = DB::table('customers as c')
    ->join('sales as s', 'c.customer_id', '=', 's.customer_id')
    ->join('business_partners as bp', 's.partner_id', '=', 'bp.id')
    ->distinct()
    ->select(
        'bp.business_name',
        'bp.address_line_1',
        'bp.address_line_2',
        'bp.poc_first_name',
        'bp.poc_last_name',
        'bp.poc_email',
        'bp.poc_mobile'
    )
    ->get();
       
        return view('user_referral',compact('business_partner','results'));
    }
    
    public function user_transaction()
    {
        
        
       $user = Session::get('user');
       
        $customer = Customer::find($user['id']);
        $sale = Sale::where('customer_id',$user['customer_id'])->count();
        $sale_cal = Sale::where('customer_id',$user['customer_id'])->sum('price');
       
       $results = DB::table('lotteries as l')
    ->join('sales as s', 'l.id', '=', 's.lottery_id')
    ->join('business_partners as bp', 's.partner_id', '=', 'bp.id')
    ->select(
        'l.lottery_name',
        'l.ticket_id',
        'bp.business_name',
        'bp.poc_first_name',
        'bp.poc_email',
        'bp.poc_mobile',
        's.price',
        's.qty',
        's.discount',
        's.tax',
        's.status'
    )->where('s.customer_id',$user['customer_id'])
    ->get();
       
        return view('user_transaction',compact('results','sale','sale_cal','customer'));
    }
    public function contact(){
        return view('contact');
    }
    public function user_support()
    {
        $user = Session::get('user');
        $total_ticket = Support::where('raised_by_id',$user['customer_id'])->count();
        $close_ticket =Support::where('raised_by_id',$user['customer_id'])->where('status',2)->count();
        $support_data  = DB::table('support')
            ->join('support_categories', 'support.categoryid', '=', 'support_categories.id')
            ->select('support.*', 'support_categories.name as category_name')
            ->get();
        $support_categories = Support_Category::get();
        
        return view('user_support',compact('support_categories','total_ticket','close_ticket','support_data'));
    }    
    public function insert_support(Request $request){
         $currentYear = Carbon::now()->format('y'); // Get last two digits of the year
        $lastSupportId = DB::table('support')
    ->select(DB::raw("MAX(CAST(SUBSTRING(support_ticket_id, 4) AS UNSIGNED)) as max_id"))
    ->first();

if ($lastSupportId && $lastSupportId->max_id) {
    $newNumber = str_pad($lastSupportId->max_id + 1, 6, '0', STR_PAD_LEFT);
} else {
    $newNumber = '000001';
}

$newSupportId = 'CST' . $newNumber;
        
        $support = new Support();
        $support->support_ticket_id = $newSupportId;
        $support->raised_by_id = $request->customer_id;
        $support->raised_by = 2; //2= Customer
        $support->categoryid = $request->categoryid;
        $support->subject = $request->subject;
        $support->description = $request->description;
        $support->status = 0; 
        $support->save();
        return redirect('user_support');
    }
    
    
     public function faq(Request $request){
            $faqs = Faq::get();
            
            return view('faq',compact('faqs'));
     }
 
 
//     function get_country(Request $request){
//         // dd($request->country_id);
//         $city = State::where('country_id',$request->country_id)->get();
//         return response()->json($city);
//     } 
 
 
//  function create(Request $request){
//         // dd($request);
//         $City = new City();
//          $City->country_id =$request->country_id;
//          $City->state_id =$request->state_id;
//         $City->name =$request->name;
//         $City->status = 1;
//         $City->save();
        
//         // $success = "City has been Added.";
//         return redirect('city')->with('success', 'City has been Added.');
//     }
       
 
 
//   function edit($id){
           
//           $country = Country::get();
//           $city = City::select('city.*', 'state.state_title', 'country.country_name')
//         ->join('state', 'city.state_id', '=', 'state.id') // Join city with state
//         ->join('country', 'city.country_id', '=', 'country.id') // Join city with country
//         ->get();
//           $city_edit = City::find($id);
//         // dd($city_edit);
//         return view('city',compact('city','city_edit','country'));
//       } 
      
      
//       function update(Request $request,$id){
//         //   dd($id);
//           $City = City::find($id);
//             $City->country_id =$request->country_id;
//              $City->state_id =$request->state_id;
//         $City->name =$request->name;
//         // $city->status = 1;
//         $City->update();
//         //  return back()->with('success', 'Business Area Has Been Updated.');
//          return redirect('city')->with('success', 'City Has Been Updated');
//       }
      
      
//       function status($id,$actions){
//           if($actions == 1){
//               $city = City::find($id);
//               $city->status = 0;
//               $city->update();
//           }
//           else{
//               $city = City::find($id);
//               $city->status = 1;
//               $city->update();
//           }
//           return redirect('city')->with('success', 'Suspend Has Been Updated');
//       }
      
//       function delete($id){
//           $city = City::find($id);
//           $city->delete();
//           return redirect('city')->with('success', 'Record has been Delete');
      
//       }
     
     
}
